/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Stack;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_279;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4599;
import net.minecraft.class_4604;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_750;
import net.minecraft.class_758;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.class_846;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.block_manipulation.BlockManipulationClient;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisInterface;
import qouteall.imm_ptl.core.compat.sodium_compatibility.SodiumInterface;
import qouteall.imm_ptl.core.ducks.IEGameRenderer;
import qouteall.imm_ptl.core.ducks.IEMinecraftClient;
import qouteall.imm_ptl.core.ducks.IEParticleManager;
import qouteall.imm_ptl.core.ducks.IEWorldRenderer;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;
import qouteall.imm_ptl.core.mixin.client.render.IERenderSystem;
import qouteall.imm_ptl.core.mixin.client.render.IESectionRenderDispatcher;
import qouteall.imm_ptl.core.render.VisibleSectionDiscovery;
import qouteall.imm_ptl.core.render.context_management.DimensionRenderHelper;
import qouteall.imm_ptl.core.render.context_management.FogRendererContext;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.q_misc_util.my_util.LimitedLogger;

@Environment(value=EnvType.CLIENT)
public class MyGameRenderer {
    public static final class_310 client = class_310.method_1551();
    private static final LimitedLogger limitedLogger = new LimitedLogger(10);
    private static Stack<class_4599> secondaryRenderBuffers = new Stack();
    private static int usingRenderBuffersObjectNum = 0;
    public static int vanillaTerrainSetupOverride = 0;
    public static boolean enablePortalCaveCulling = true;

    public static void init() {
        IPCGlobal.CLIENT_CLEANUP_EVENT.register(() -> secondaryRenderBuffers.clear());
    }

    @Nullable
    private static class_4599 acquireRenderBuffersObject() {
        ++usingRenderBuffersObjectNum;
        if (secondaryRenderBuffers.isEmpty()) {
            return new class_4599(0);
        }
        return secondaryRenderBuffers.pop();
    }

    private static void returnRenderBuffersObject(class_4599 renderBuffers) {
        --usingRenderBuffersObjectNum;
        secondaryRenderBuffers.push(renderBuffers);
    }

    public static void renderWorldNew(WorldRenderInfo worldRenderInfo, Consumer<Runnable> invokeWrapper) {
        WorldRenderInfo.pushRenderInfo(worldRenderInfo);
        MyGameRenderer.switchAndRenderTheWorld(worldRenderInfo.world, worldRenderInfo.cameraPos, worldRenderInfo.cameraPos, invokeWrapper, worldRenderInfo.renderDistance, worldRenderInfo.doRenderHand);
        WorldRenderInfo.popRenderInfo();
    }

    private static void switchAndRenderTheWorld(class_638 newWorld, class_243 thisTickCameraPos, class_243 lastTickCameraPos, Consumer<Runnable> invokeWrapper, int renderDistance, boolean doRenderHand) {
        if (!enablePortalCaveCulling) {
            MyGameRenderer.client.field_1730 = false;
        }
        if (!PortalRendering.shouldEnableSodiumCaveCulling()) {
            MyGameRenderer.client.field_1730 = false;
        }
        class_5321 newDimension = newWorld.method_27983();
        class_761 worldRenderer = ClientWorldLoader.getWorldRenderer((class_5321<class_1937>)newDimension);
        CHelper.checkGlError();
        IEGameRenderer ieGameRenderer = (IEGameRenderer)MyGameRenderer.client.field_1773;
        DimensionRenderHelper helper = ClientWorldLoader.getDimensionRenderHelper((class_5321<class_1937>)newDimension);
        class_4184 newCamera = new class_4184();
        class_638 oldWorld = MyGameRenderer.client.field_1687;
        class_761 oldWorldRenderer = MyGameRenderer.client.field_1769;
        class_765 oldLightmap = MyGameRenderer.client.field_1773.method_22974();
        boolean oldNoClip = MyGameRenderer.client.field_1724.field_5960;
        boolean oldDoRenderHand = ieGameRenderer.ip_getDoRenderHand();
        ObjectArrayList<class_846.class_851> oldChunkInfoList = ((IEWorldRenderer)oldWorldRenderer).portal_getChunkInfoList();
        class_239 oldCrosshairTarget = MyGameRenderer.client.field_1765;
        class_4184 oldCamera = MyGameRenderer.client.field_1773.method_19418();
        class_279 oldTransparencyShader = ((IEWorldRenderer)worldRenderer).portal_getTransparencyShader();
        class_4599 oldRenderBuffers = ((IEWorldRenderer)worldRenderer).ip_getRenderBuffers();
        class_4599 oldClientRenderBuffers = client.method_22940();
        class_750 oldSectionRenderDispatcherFixedBuffers = ((IESectionRenderDispatcher)worldRenderer.method_34810()).ip_getFixedBuffers();
        class_4604 oldFrustum = ((IEWorldRenderer)worldRenderer).portal_getFrustum();
        Matrix4f oldProjectionMatrix = RenderSystem.getProjectionMatrix();
        Matrix4fStack oldModelViewStack = IERenderSystem.ip_getModelViewStack();
        ObjectArrayList<class_846.class_851> newChunkInfoList = VisibleSectionDiscovery.takeList();
        ((IEWorldRenderer)oldWorldRenderer).portal_setChunkInfoList(newChunkInfoList);
        Object irisPipeline = IrisInterface.invoker.getPipeline(worldRenderer);
        ((IEMinecraftClient)client).ip_setWorldRenderer(worldRenderer);
        MyGameRenderer.client.field_1687 = newWorld;
        ieGameRenderer.ip_setLightmapTextureManager(helper.lightmapTexture);
        MyGameRenderer.client.method_31975().field_4348 = newWorld;
        MyGameRenderer.client.field_1724.field_5960 = true;
        MyGameRenderer.client.field_1773.method_35768(doRenderHand);
        FogRendererContext.swappingManager.pushSwapping((class_5321<class_1937>)newDimension);
        ((IEParticleManager)MyGameRenderer.client.field_1713).ip_setWorld(newWorld);
        if (BlockManipulationClient.remotePointedDim == newDimension) {
            MyGameRenderer.client.field_1765 = BlockManipulationClient.remoteHitResult;
        }
        if (!PortalRendering.shouldRenderHitResult()) {
            MyGameRenderer.client.field_1765 = null;
        }
        ieGameRenderer.ip_setCamera(newCamera);
        class_4599 newRenderBuffers = null;
        if (IPGlobal.useSecondaryEntityVertexConsumer) {
            newRenderBuffers = MyGameRenderer.acquireRenderBuffersObject();
            if (newRenderBuffers != null) {
                ((IEWorldRenderer)worldRenderer).ip_setRenderBuffers(newRenderBuffers);
                ((IEMinecraftClient)client).ip_setRenderBuffers(newRenderBuffers);
                ((IESectionRenderDispatcher)worldRenderer.method_34810()).ip_setFixedBuffers(newRenderBuffers.method_22997());
            } else {
                client.method_22940().method_23000().method_22993();
            }
        }
        Object newSodiumContext = SodiumInterface.invoker.createNewContext(renderDistance);
        SodiumInterface.invoker.switchContextWithCurrentWorldRenderer(newSodiumContext);
        ((IEWorldRenderer)worldRenderer).portal_setTransparencyShader(null);
        IERenderSystem.ip_setModelViewStack(new Matrix4fStack(16));
        RenderSystem.applyModelViewMatrix();
        IrisInterface.invoker.setPipeline(worldRenderer, null);
        if (!RenderStates.isDimensionRendered((class_5321<class_1937>)newDimension)) {
            helper.lightmapTexture.method_3313(0.0f);
        }
        invokeWrapper.accept(() -> {
            client.method_16011().method_15396("render_portal_content");
            MyGameRenderer.client.field_1773.method_3188(client.method_60646());
            client.method_16011().method_15407();
        });
        SodiumInterface.invoker.switchContextWithCurrentWorldRenderer(newSodiumContext);
        ((IEMinecraftClient)client).ip_setWorldRenderer(oldWorldRenderer);
        MyGameRenderer.client.field_1687 = oldWorld;
        ieGameRenderer.ip_setLightmapTextureManager(oldLightmap);
        MyGameRenderer.client.method_31975().field_4348 = oldWorld;
        MyGameRenderer.client.field_1724.field_5960 = oldNoClip;
        MyGameRenderer.client.field_1773.method_35768(oldDoRenderHand);
        ((IEParticleManager)MyGameRenderer.client.field_1713).ip_setWorld(oldWorld);
        MyGameRenderer.client.field_1765 = oldCrosshairTarget;
        ieGameRenderer.ip_setCamera(oldCamera);
        ((IEWorldRenderer)worldRenderer).portal_setTransparencyShader(oldTransparencyShader);
        FogRendererContext.swappingManager.popSwapping();
        ((IEWorldRenderer)oldWorldRenderer).portal_setChunkInfoList(oldChunkInfoList);
        VisibleSectionDiscovery.returnList(newChunkInfoList);
        ((IEWorldRenderer)worldRenderer).ip_setRenderBuffers(oldRenderBuffers);
        ((IEMinecraftClient)client).ip_setRenderBuffers(oldClientRenderBuffers);
        ((IESectionRenderDispatcher)worldRenderer.method_34810()).ip_setFixedBuffers(oldSectionRenderDispatcherFixedBuffers);
        if (newRenderBuffers != null) {
            MyGameRenderer.returnRenderBuffersObject(newRenderBuffers);
        }
        ((IEWorldRenderer)worldRenderer).portal_setFrustum(oldFrustum);
        MyGameRenderer.client.field_1773.method_22709(oldProjectionMatrix);
        IERenderSystem.ip_setModelViewStack(oldModelViewStack);
        RenderSystem.applyModelViewMatrix();
        IrisInterface.invoker.setPipeline(worldRenderer, irisPipeline);
        client.method_1561().method_3941((class_1937)MyGameRenderer.client.field_1687, oldCamera, MyGameRenderer.client.field_1692);
        CHelper.checkGlError();
        MyGameRenderer.client.field_1730 = true;
    }

    @IPVanillaCopy
    public static void resetFogState() {
        class_4184 camera = MyGameRenderer.client.field_1773.method_19418();
        float g = MyGameRenderer.client.field_1773.method_3193();
        class_243 cameraPos = camera.method_19326();
        double x = cameraPos.method_10216();
        double y = cameraPos.method_10214();
        double z = cameraPos.method_10215();
        boolean isFoggy = MyGameRenderer.client.field_1687.method_28103().method_28110(class_3532.method_15357((double)x), class_3532.method_15357((double)y)) || MyGameRenderer.client.field_1705.method_1740().method_1800();
        class_758.method_3211((class_4184)camera, (class_758.class_4596)class_758.class_4596.field_20946, (float)Math.max(g, 32.0f), (boolean)isFoggy, (float)RenderStates.getPartialTick());
        class_758.method_3212();
    }

    public static void updateFogColor() {
        class_758.method_3210((class_4184)MyGameRenderer.client.field_1773.method_19418(), (float)RenderStates.getPartialTick(), (class_638)MyGameRenderer.client.field_1687, (int)MyGameRenderer.client.field_1690.method_38521(), (float)MyGameRenderer.client.field_1773.method_3195(RenderStates.getPartialTick()));
    }

    @IPVanillaCopy
    public static void resetDiffuseLighting() {
        class_638 world = MyGameRenderer.client.field_1687;
        assert (world != null);
        if (world.method_28103().method_29993()) {
            class_308.method_1452();
        } else {
            class_308.method_27869();
        }
    }
}

